package ru.yandex.direct.tvm;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Белый список tvm client id, ограничивает доступ на уровне контроллера(метода или класса)
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface AllowServices {
    TvmService[] production();

    TvmService[] testing() default {TvmService.DIRECT_DEVELOPER};

    TvmService[] sandbox() default {};

    TvmService[] sandboxTesting() default {};
}
