package ru.yandex.direct.tvm;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TvmConfig {
    /**
     * Секрет tvm, обычно хранится в ресурках https://abc.yandex-team.ru/resources
     */
    private String tvmSecret;
    private final TvmService service;
    private final String tvmApiUrl;

    /**
     * SO_TIMEOUT http клиента к tvm-api
     */
    private final Duration soTimeout;

    /**
     * CONNECT_TIMEOUT http клиента к tvm-api
     */
    private final Duration connectTimeout;

    /**
     * период обновления сервисных тикетов
     */
    private final Duration updateDelay;

    /**
     * период перезапуск обновления тикетов в случае ошибки внутри Tvm2
     */
    private final Duration errorDelay;

    TvmConfig(TvmService service, String tvmApiUrl, Duration soTimeout, Duration connectTimeout,
              Duration updateDelay, Duration errorDelay) {
        this.service = service;
        this.tvmApiUrl = tvmApiUrl;
        this.soTimeout = soTimeout;
        this.connectTimeout = connectTimeout;
        this.updateDelay = updateDelay;
        this.errorDelay = errorDelay;
    }

    TvmService getService() {
        return service;
    }

    int getServiceClientId() {
        return service.getId();
    }

    void setTvmSecret(String tvmSecret) {
        if (tvmSecret.endsWith("\n")) {
            tvmSecret = tvmSecret.substring(0, tvmSecret.length() - 1);
        }
        this.tvmSecret = tvmSecret;
    }

    String getTvmSecret() {
        return tvmSecret;
    }

    String getTvmApiUrl() {
        return tvmApiUrl;
    }

    Duration getSoTimeout() {
        return soTimeout;
    }

    Duration getConnectTimeout() {
        return connectTimeout;
    }

    Duration getUpdateDelay() {
        return updateDelay;
    }

    Duration getErrorDelay() {
        return errorDelay;
    }
}
