package ru.yandex.direct.tvm;

import ru.yandex.inside.passport.tvm2.exceptions.IncorrectTvmServiceTicketException;
import ru.yandex.inside.passport.tvm2.exceptions.IncorrectTvmUserTicketException;

public interface TvmIntegration extends AutoCloseable {
    String SERVICE_TICKET_HEADER = "X-Ya-Service-Ticket";
    String USER_TICKET_HEADER = "X-Ya-User-Ticket";
    String TVM_SERVICE_ID_ATTRIBUTE_NAME = TvmIntegration.class.getCanonicalName() + ".tvm_service_id";

    boolean isEnabled();

    /**
     * Получить tvm тикет для сервиса. Он будет проставлен в загологок "X-Ya-Service-Ticket"
     */
    String getTicket(TvmService service);

    /**
     * Получить {@link TvmService}, который сделал запрос
     */
    TvmService getTvmService(String ticket) throws IncorrectTvmServiceTicketException;

    /**
     * Проверяет UserTicket, в случае успеха возвращает uid пользователя.
     */
    long checkUserTicket(String ticket) throws IncorrectTvmUserTicketException;

    TvmService currentTvmService();

    default String serviceTicketHeaderName() {
        return SERVICE_TICKET_HEADER;
    }
}
