package ru.yandex.direct.web.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Позволяет дать доступ на уровне контроллера/резолвера заблокированному оператору или пользователю из ulogin
 * Аннотация может быть установлены над методом или классом контроллеров.
 * Для GraphQL аннотация проверяется только для методов мутаций (@GraphQLMutation), а методы запросов(GraphQLQuery)
 * считаем доступным заблокированным пользователям всегда
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface AllowedBlockedOperatorOrUser {
}
