package ru.yandex.direct.web.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.rbac.RbacRole;

/**
 * Позволяет ограничить на уровне контроллера роли оператора
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface AllowedOperatorRoles {
    RbacRole[] value() default {RbacRole.SUPER, RbacRole.SUPERREADER, RbacRole.SUPPORT, RbacRole.PLACER,
            RbacRole.MEDIA, RbacRole.MANAGER, RbacRole.AGENCY, RbacRole.CLIENT};
}
