package ru.yandex.direct.web.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.rbac.RbacRole;

/**
 * Позволяет ограничить на уровне контроллера роли субъекта(ulogin или clientUid) для операции
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface AllowedSubjectRoles {
    //если не ставить аннотацию над контроллером либо оставить значeние пустым, субъект операции может быть только
    //клиентом
    RbacRole[] value() default RbacRole.CLIENT;
}
