package ru.yandex.direct.web.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.feature.FeatureName;

/**
 * Позволяет предоставить доступ к контроллеру/ручке оператору, у которого есть доступ ко всем заданным фичам
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
@Repeatable(OperatorHasOneFeaturesSet.class)
public @interface OperatorHasFeatures {
    FeatureName[] value();
}
