package ru.yandex.direct.web.auth.blackbox;

import java.util.Collection;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

/**
 * Request for authentication at blackbox.
 * All interface methods are final stubs except {@code getCredentials}.
 */
public abstract class BlackboxAuthRequest implements Authentication {
    @Override
    public final Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    @Override
    public final Object getDetails() {
        return null;
    }

    @Override
    public final Object getPrincipal() {
        return null;
    }

    @Override
    public final boolean isAuthenticated() {
        return false;
    }

    @Override
    public final void setAuthenticated(boolean isAuthenticated) {
        if (isAuthenticated) {
            throw new IllegalArgumentException("can not set \"authenticated\" property");
        }
    }

    @Override
    public final String getName() {
        return null;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
