package ru.yandex.direct.web.auth.blackbox;

import javax.annotation.Nullable;

import org.springframework.security.core.Authentication;

public interface BlackboxBasedAuth extends Authentication {

    Long getUid();

    /**
     * @return user login
     */
    @Override
    String getPrincipal();

    /**
     * @return user login
     */
    @Override
    default String getName() {
        return getPrincipal();
    }

    /**
     * логин принадлежит Почте-для-домена
     */
    default boolean isHostedPdd() {
        return false;
    }

    /**
     * There is no details for Blackbox based authentication
     *
     * @return {@code null}
     */
    @Override
    default Object getDetails() {
        return null;
    }

    /**
     * Blackbox authentication is not final for application
     * and than can not be "authenticated".
     *
     * @return {@code false}
     */
    @Override
    default boolean isAuthenticated() {
        return false;
    }

    /**
     * Blackbox authentication is not final for application
     * and than can not be "authenticated".
     */
    @Override
    default void setAuthenticated(boolean isAuthenticated) {
        if (isAuthenticated) {
            throw new IllegalArgumentException("can not set \"authenticated\" property");
        }
    }

    @Nullable
    default String getTvmUserTicket() {
        return null;
    }
}
