package ru.yandex.direct.web.auth.blackbox;

import java.util.Collection;

import javax.annotation.Nullable;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;


/**
 * Completed blackbox authentication.
 * It is used as authentication request for internal authentication
 * and can not be used as completed authentication in application.
 */
public class BlackboxCookieAuth implements BlackboxBasedAuth {
    private final BlackboxCorrectResponse sessionIdResponse;
    private final BlackboxCookieCredentials credentials;

    public BlackboxCookieAuth(BlackboxCorrectResponse sessionIdResponse, BlackboxCookieCredentials credentials) {
        Assert.notNull(sessionIdResponse, "sessionIdResponse is required");
        this.sessionIdResponse = sessionIdResponse;
        this.credentials = credentials;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    @Override
    public BlackboxCookieCredentials getCredentials() {
        return credentials;
    }

    public BlackboxCorrectResponse getSessionIdResponse() {
        return sessionIdResponse;
    }


    @Override
    public Long getUid() {
        return sessionIdResponse.getUid().toOptional()
                .orElseThrow(() -> new AuthenticationServiceException("No Uid in Blackbox response."))
                .getUid();
    }

    @Override
    public String getPrincipal() {
        return sessionIdResponse.getLogin().toOptional()
                .orElseThrow(() -> new AuthenticationServiceException("No login in Blackbox response."));
    }

    @Nullable
    @Override
    public String getTvmUserTicket() {
        return sessionIdResponse.getTvmUserTicket().getOrNull();
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

}
