package ru.yandex.direct.web.auth.blackbox;

import javax.annotation.Nullable;

/**
 * Request for authentication at blackbox by cookies.
 * Contains only credentials obtained from user request (cookies and some other info).
 */
public class BlackboxCookieAuthRequest extends BlackboxAuthRequest {

    private final BlackboxCookieCredentials credentials;
    private final String tvmTicket;

    /**
     * Запрос на авторизацию с Service-тикетом TVM
     */
    public BlackboxCookieAuthRequest(BlackboxCookieCredentials credentials, String tvmTicket) {
        this.credentials = credentials;
        this.tvmTicket = tvmTicket;
    }

    @Override
    public BlackboxCookieCredentials getCredentials() {
        return credentials;
    }

    @Nullable
    public String getTvmTicket() {
        return tvmTicket;
    }
}
