package ru.yandex.direct.web.auth.blackbox;

import java.util.Collection;
import java.util.Objects;

import org.springframework.security.core.GrantedAuthority;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Реализация фэйковой аутентификации, логин и uid подставляются из http-заголовка.
 * Используется только для разработки.
 */
public class BlackboxCookieFakeAuth implements BlackboxBasedAuth {
    private final long uid;
    private final String login;

    public BlackboxCookieFakeAuth(long uid, String login) {
        checkNotNull(login);
        this.uid = uid;
        this.login = login;
    }

    @Override
    public Long getUid() {
        return uid;
    }

    @Override
    public String getPrincipal() {
        return login;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    @Override
    public Object getCredentials() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BlackboxCookieFakeAuth that = (BlackboxCookieFakeAuth) o;
        return uid == that.uid &&
                Objects.equals(login, that.login);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, login);
    }

    @Override
    public String toString() {
        return "BlackboxCookieFakeAuth{" +
                "uid=" + uid +
                ", login='" + login + '\'' +
                '}';
    }
}
