package ru.yandex.direct.web.auth.blackbox;

import java.util.Collection;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;

public class BlackboxOauthAuth implements BlackboxBasedAuth {
    private final BlackboxCorrectResponse oauthResponse;
    private final BlackboxOauthCredentials credentials;

    public BlackboxOauthAuth(BlackboxCorrectResponse oauthResponse, BlackboxOauthCredentials credentials) {
        Assert.notNull(oauthResponse, "sessionIdResponse is required");
        this.oauthResponse = oauthResponse;
        this.credentials = credentials;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    @Override
    public BlackboxOauthCredentials getCredentials() {
        return credentials;
    }

    public BlackboxCorrectResponse getOauthResponse() {
        return oauthResponse;
    }

    @Override
    public Long getUid() {
        return oauthResponse.getUid().toOptional()
                .orElseThrow(() -> new AuthenticationServiceException("No Uid in Blackbox response."))
                .getUid();
    }

    @Override
    public String getPrincipal() {
        return oauthResponse.getLogin().toOptional()
                .orElseThrow(() -> new AuthenticationServiceException("No login in Blackbox response."));
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
