package ru.yandex.direct.web.auth.blackbox;

import javax.annotation.Nullable;

/**
 * Request for authentication at blackbox by oath token.
 * Contains only credentials obtained from user request (token and some other info).
 */
public class BlackboxOauthAuthRequest extends BlackboxAuthRequest {
    private final BlackboxOauthCredentials credentials;
    @Nullable
    private final String tvmTicket;

    /**
     * tvmTicket может быть Null только в тестах, но в будущем в них тоже будет добавлен.
     * Для Prod - tvm тикет обязателен!
     */
    public BlackboxOauthAuthRequest(BlackboxOauthCredentials credentials, @Nullable String tvmTicket) {
        this.credentials = credentials;
        this.tvmTicket = tvmTicket;
    }

    @Override
    public BlackboxOauthCredentials getCredentials() {
        return credentials;
    }

    @Nullable
    public String getTvmTicket() {
        return tvmTicket;
    }
}
