package ru.yandex.direct.web.auth.blackbox;

import java.net.InetAddress;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.direct.common.util.HttpUtil;

public class BlackboxOauthCredentials {

    private final String host;
    private final InetAddress userIp;
    private final String oauthToken;

    public BlackboxOauthCredentials(HttpServletRequest request,
                                    InetAddress userIp) {
        this.host = request.getServerName();
        this.userIp = userIp;
        this.oauthToken = HttpUtil.extractBearerToken(request).orElse(null);
    }

    public BlackboxOauthCredentials(String host, InetAddress userIp, String oauthToken) {
        this.host = host;
        this.userIp = userIp;
        this.oauthToken = oauthToken;
    }

    public boolean isPopulated() {
        return host != null && userIp != null && oauthToken != null;
    }

    public String getHost() {
        return host;
    }

    public InetAddress getUserIp() {
        return userIp;
    }

    public String getOauthToken() {
        return oauthToken;
    }
}
