package ru.yandex.direct.web.core;

import java.beans.PropertyEditorSupport;
import java.io.IOException;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

/**
 * Поддержка json form-параметров в http-запросах
 * Чтобы spring контроллер мог обрабатывать такие параметры, нужно настроить WebDataBinder
 *
 * @param <T>
 */
public class JsonPropertyEditor<T> extends PropertyEditorSupport {
    private Class<T> clazz;

    private static final ObjectMapper MAPPER;

    static {
        MAPPER = new ObjectMapper();
        MAPPER.registerModule(new JavaTimeModule());
    }

    public JsonPropertyEditor(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void setAsText(String text) {
        try {
            setValue(MAPPER.readValue(text, this.clazz));
        } catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}
