package ru.yandex.direct.web.core;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

public class WebLocaleResolver extends AcceptHeaderLocaleResolver {
    public static final String DETECTED_LOCALE_HEADER_NAME = "X-Detected-Locale";
    public static final Locale DEFAULT_LOCALE = new Locale("en");

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        Object locale = request.getAttribute(DETECTED_LOCALE_HEADER_NAME);
        if (locale == null) {
            return DEFAULT_LOCALE;
        }
        return (Locale) locale;
    }
}
