package ru.yandex.direct.web.core.configuration;

import com.fasterxml.classmate.TypeResolver;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.swagger.schema.ApiModelBuilder;

import ru.yandex.direct.env.EnvironmentType;

/**
 * Чтобы не показывать документацию в проде из аннотации {@link io.swagger.annotations.ApiModel}
 */
public class DirectApiModelBuilder extends ApiModelBuilder {
    private final EnvironmentType environmentType;

    DirectApiModelBuilder(TypeResolver typeResolver, EnvironmentType environmentType) {
        super(typeResolver);
        this.environmentType = environmentType;
    }

    @Override
    public void apply(ModelContext context) {
        if (environmentType.isDevelopment() || environmentType.isBeta()) {
            super.apply(context);
        }
    }
}
