package ru.yandex.direct.web.core.configuration;

import springfox.documentation.spi.schema.contexts.ModelPropertyContext;
import springfox.documentation.swagger.schema.ApiModelPropertyPropertyBuilder;

import ru.yandex.direct.env.EnvironmentType;

/**
 * Чтобы не показывать документацию в проде из аннотации {@link io.swagger.annotations.ApiModelProperty}
 */
public class DirectModelPropertyBuilderPlugin extends ApiModelPropertyPropertyBuilder {

    private final EnvironmentType environmentType;

    DirectModelPropertyBuilderPlugin(EnvironmentType environmentType) {
        this.environmentType = environmentType;
    }

    @Override
    public void apply(ModelPropertyContext context) {
        if (environmentType.isDevelopment() || environmentType.isBeta()) {
            super.apply(context);
        }
    }
}
