package ru.yandex.direct.web.core.configuration;

import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.readers.operation.OperationSummaryReader;

import ru.yandex.direct.env.EnvironmentType;

/**
 * Чтобы не показывать документацию в проде из аннотации {@link io.swagger.annotations.ApiOperation}
 */
public class DirectOperationSummaryReader extends OperationSummaryReader {

    private final EnvironmentType environmentType;

    DirectOperationSummaryReader(EnvironmentType environmentType) {
        this.environmentType = environmentType;
    }

    @Override
    public void apply(OperationContext context) {
        if (environmentType.isDevelopment() || environmentType.isBeta()) {
            super.apply(context);
        }
    }
}
