package ru.yandex.direct.web.core.configuration;

import org.asynchttpclient.AsyncHttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.captcha.passport.YandexCaptchaClient;
import ru.yandex.direct.captcha.passport.YandexCaptchaConfig;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.lettuce.LettuceConnectionProvider;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.core.security.authentication.DirectWebAuthenticationInterceptor;
import ru.yandex.direct.web.core.security.captcha.CaptchaFirewallInterceptor;
import ru.yandex.direct.web.core.security.captcha.CaptchaFirewallInterceptorConfig;
import ru.yandex.direct.web.core.security.configuration.BlackboxWebAuthenticationConfiguration;
import ru.yandex.direct.web.core.security.configuration.NetAclConfiguration;

import static ru.yandex.direct.common.configuration.RedisConfiguration.LETTUCE;

@Configuration
@ComponentScan(
        basePackages = "ru.yandex.direct.web.core.security",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@Import({
        CoreConfiguration.class,
        BlackboxWebAuthenticationConfiguration.class,
        NetAclConfiguration.class
})
public class SecurityConfiguration {

    public static final String YANDEX_CAPTCHA_CLIENT = "yandexCaptchaClient";

    @Bean(name = YANDEX_CAPTCHA_CLIENT)
    public YandexCaptchaClient yandexCaptchaClient(DirectConfig directConfig, AsyncHttpClient defaultAhc) {
        DirectConfig cfg = directConfig.getBranch("yandex_captcha");
        YandexCaptchaConfig captchaConfig =
                new YandexCaptchaConfig(cfg.getString("url_base"), cfg.getString("http_host_header"));
        return new YandexCaptchaClient(captchaConfig, defaultAhc);
    }

    @Bean
    public CaptchaFirewallInterceptor captchaFirewallInterceptor(
            CaptchaFirewallInterceptorConfig config,
            @Qualifier(LETTUCE) LettuceConnectionProvider lettuce,
            YandexCaptchaClient yandexCaptchaClient,
            DirectWebAuthenticationSource authenticationSource,
            @Value("${multipart_config.default_encoding}") String defaultEncoding,
            PpcPropertiesSupport ppcPropertiesSupport) {
        return new CaptchaFirewallInterceptor(config, lettuce, yandexCaptchaClient, authenticationSource,
                defaultEncoding, ppcPropertiesSupport);
    }

    @Bean
    public CaptchaFirewallInterceptorConfig captchaFirewallInterceptorConfig(
            @Value("${direct_captcha.captcha_solving_page}") String captchaSolvingPageUrl,
            @Value("${direct_captcha.autoban_captcha_freq}") long autobanCaptchaFreq,
            DirectConfig directConfig,
            EnvironmentType env
    ) {
        return new CaptchaFirewallInterceptorConfig(captchaSolvingPageUrl,
                autobanCaptchaFreq, directConfig, env, "captcha");
    }

    @Bean
    public DirectWebAuthenticationInterceptor directWebAuthenticationInterceptor(
            FeatureService featureService,
            DirectWebAuthenticationSource authenticationSource
    ) {
        return new DirectWebAuthenticationInterceptor(featureService, authenticationSource);
    }
}
