package ru.yandex.direct.web.core.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;

@Configuration
@ComponentScan(
        basePackages = "ru.yandex.direct.web.core.entity",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@Import({
        CoreConfiguration.class
})
public class WebCoreConfiguration {
    @Bean(DirectWebAuthenticationSource.BEAN_NAME)
    @Lazy
    public DirectWebAuthenticationSource directWebAuthenticationSource() {
        return new DirectWebAuthenticationSource();
    }
}
