package ru.yandex.direct.web.core.entity.adqualityexport;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class AdQualityExportLogEntity {
    //тип действия
    private AdQualityExportActionType actionType;
    //сама добавленная/исключенная фраза (клиент может изменить ее до неузнаваемости)
    private String userProvidedText;
    private String userNormText;
    private Long cid;
    private Long pid;
    private String reportRowHash;


    public AdQualityExportActionType getActionType() {
        return actionType;
    }

    public String getUserProvidedText() {
        return userProvidedText;
    }

    public Long getCid() {
        return cid;
    }

    public Long getPid() {
        return pid;
    }

    public String getUserNormText() {
        return userNormText;
    }

    public String getReportRowHash() {
        return reportRowHash;
    }

    public AdQualityExportLogEntity withActionType(AdQualityExportActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public AdQualityExportLogEntity withUserProvidedText(String userProvidedText) {
        this.userProvidedText = userProvidedText;
        return this;
    }

    public AdQualityExportLogEntity withUserNormText(String normText) {
        this.userNormText = normText;
        return this;
    }

    public AdQualityExportLogEntity withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    public AdQualityExportLogEntity withPid(Long pid) {
        this.pid = pid;
        return this;
    }

    public AdQualityExportLogEntity withReportRowHash(String reportRowHash) {
        this.reportRowHash = reportRowHash;
        return this;
    }
}
