package ru.yandex.direct.web.core.entity.adqualityexport;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.tracing.Trace;
import ru.yandex.direct.tracing.real.RealTrace;
import ru.yandex.direct.utils.JsonUtils;

public abstract class AdQualityExportLoggerBase {
    private static final Logger messagesLogger = LoggerFactory.getLogger(AdQualityExportLoggerBase.class);

    protected void doLogForExport(List<AdQualityExportLogEntity> logEntities) {
        Trace trace = RealTrace.builder()
                .withMethod("export.okr.pz_report_alter_log")
                .build();
        boolean tracePushed = false;
        try {
            Trace.push(trace);
            tracePushed = true;
            for (AdQualityExportLogEntity logEntity : logEntities) {
                messagesLogger.info(JsonUtils.toJson(logEntity));
            }
        } finally {
            if (tracePushed) {
                Trace.pop();
            }
        }
    }
}
