package ru.yandex.direct.web.core.entity.banner.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebImageFormat {
    public static class Prop {
        private Prop() {
        }

        public static final String PATH = "path";
        public static final String IMAGE_SIZE = "image_size";
        public static final String SMART_CENTERS = "smart_centers";
    }

    @JsonProperty(Prop.PATH)
    private String path;

    @JsonProperty(Prop.IMAGE_SIZE)
    private WebImageSize imageSize;

    @JsonProperty(Prop.SMART_CENTERS)
    private List<WebImageSmartCenter> smartCenters;

    public String getPath() {
        return path;
    }

    public WebImageFormat withPath(String path) {
        this.path = path;
        return this;
    }

    public WebImageSize getImageSize() {
        return imageSize;
    }

    public WebImageFormat withImageSize(WebImageSize imageSize) {
        this.imageSize = imageSize;
        return this;
    }

    public List<WebImageSmartCenter> getSmartCenters() {
        return smartCenters;
    }

    public WebImageFormat withSmartCenters(
            List<WebImageSmartCenter> smartCenters) {
        this.smartCenters = smartCenters;
        return this;
    }
}
