package ru.yandex.direct.web.core.entity.banner.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebImageSize {
    public static class Prop {
        private Prop() {
        }

        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
    }

    @JsonProperty(Prop.WIDTH)
    private int width;

    @JsonProperty(Prop.HEIGHT)
    private int height;

    public int getWidth() {
        return width;
    }

    public WebImageSize withWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return height;
    }

    public WebImageSize withHeight(int height) {
        this.height = height;
        return this;
    }
}
