package ru.yandex.direct.web.core.entity.banner.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebImageSmartCenter {
    public static class Prop {
        private Prop() {
        }

        public static final String RATIO = "ratio";
        public static final String HEIGHT = "height";
        public static final String WIDTH = "width";
        public static final String X = "x";
        public static final String Y = "y";

    }

    @JsonProperty(Prop.RATIO)
    private String ratio;

    @JsonProperty(Prop.HEIGHT)
    private Integer height;

    @JsonProperty(Prop.WIDTH)
    private Integer width;

    @JsonProperty(Prop.X)
    private Integer x;

    @JsonProperty(Prop.Y)
    private Integer y;

    public String getRatio() {
        return ratio;
    }

    public WebImageSmartCenter withRatio(String ratio) {
        this.ratio = ratio;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public WebImageSmartCenter withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public WebImageSmartCenter withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getX() {
        return x;
    }

    public WebImageSmartCenter withX(Integer x) {
        this.x = x;
        return this;
    }

    public Integer getY() {
        return y;
    }

    public WebImageSmartCenter withY(Integer y) {
        this.y = y;
        return this;
    }
}
