package ru.yandex.direct.web.core.entity.banner.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebUploadedImage {
    public static class Prop {
        private Prop() {
        }

        public static final String HASH = "hash";
        public static final String MDS_GROUP_ID = "mds_group_id";
        public static final String MDS_NAMESPACE = "mds_namespace";
        public static final String NAME = "name";
        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
        public static final String FORMATS = "formats";
    }

    @JsonProperty(Prop.HASH)
    private String hash;

    @JsonProperty(Prop.MDS_GROUP_ID)
    private int mdsGroupId;

    @JsonProperty(Prop.MDS_NAMESPACE)
    private WebMdsNamespace webMdsNamespace;

    @JsonProperty(Prop.NAME)
    private String name;

    @JsonProperty(Prop.WIDTH)
    private Integer width;

    @JsonProperty(Prop.HEIGHT)
    private Integer height;

    @JsonProperty(Prop.FORMATS)
    private List<WebImageFormat> formats;

    public String getHash() {
        return hash;
    }

    public WebUploadedImage withHash(String hash) {
        this.hash = hash;
        return this;
    }

    public int getMdsGroupId() {
        return mdsGroupId;
    }

    public WebUploadedImage withMdsGroupId(int mdsGroupId) {
        this.mdsGroupId = mdsGroupId;
        return this;
    }

    public WebMdsNamespace getWebMdsNamespace() {
        return webMdsNamespace;
    }

    public WebUploadedImage withWebMdsNamespace(WebMdsNamespace webMdsNamespace) {
        this.webMdsNamespace = webMdsNamespace;
        return this;
    }

    public String getName() {
        return name;
    }

    public WebUploadedImage withName(String name) {
        this.name = name;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public WebUploadedImage withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public WebUploadedImage withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public List<WebImageFormat> getFormats() {
        return formats;
    }

    public WebUploadedImage withFormats(List<WebImageFormat> formats) {
        this.formats = formats;
        return this;
    }
}
