package ru.yandex.direct.web.core.entity.bidmodifiers;

import java.util.List;

import ru.yandex.direct.core.entity.bidmodifier.BannerType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierBannerType;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierBannerTypeAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.dbschema.ppc.enums.BannerTypeMultiplierValuesBannerType;
import ru.yandex.direct.web.core.entity.bidmodifiers.model.BidModifierBannerTypeConditionWeb;
import ru.yandex.direct.web.core.entity.bidmodifiers.model.BidModifierBannerTypeWeb;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.web.core.entity.bidmodifiers.HelperConverter.booleanFromInt;
import static ru.yandex.direct.web.core.entity.bidmodifiers.HelperConverter.booleanToInt;

public class BannerTypeModifierConverter {

    private BannerTypeModifierConverter() {
    }

    public static BidModifierBannerType convert(BidModifierBannerTypeWeb inventoryModifier) {
        List<BidModifierBannerTypeAdjustment> conditions =
                mapList(inventoryModifier.getConditions(), BannerTypeModifierConverter::convert);

        BidModifierBannerType bidModifier = new BidModifierBannerType()
                .withType(BidModifierType.BANNER_TYPE_MULTIPLIER)
                .withEnabled(booleanFromInt(inventoryModifier.getEnabled()))
                .withBannerTypeAdjustments(conditions);
        return bidModifier;
    }

    public static BidModifierBannerTypeAdjustment convert(BidModifierBannerTypeConditionWeb condition) {
        return new BidModifierBannerTypeAdjustment()
                .withBannerType(bannerTypeFromExternal(condition.getMultiplierType()))
                .withPercent(condition.getPercent());
    }

    public static BidModifierBannerTypeConditionWeb convertToWeb(BidModifierBannerTypeAdjustment condition) {
        return new BidModifierBannerTypeConditionWeb()
                .withId(condition.getId())
                .withPercent(condition.getPercent())
                .withMultiplierType(condition.getBannerType().toString().toLowerCase())
                .withLastChange(condition.getLastChange().toString());
    }

    public static BidModifierBannerTypeWeb convertToWeb(BidModifierBannerType modifier) {
        List<BidModifierBannerTypeConditionWeb> conditions = mapList(modifier.getBannerTypeAdjustments(),
                BannerTypeModifierConverter::convertToWeb);

        return new BidModifierBannerTypeWeb()
                .withHierarchicalMultiplierId(modifier.getId())
                .withEnabled(booleanToInt(modifier.getEnabled()))
                .withLastChange(modifier.getLastChange().toString())
                .withConditions(conditions);
    }

    private static BannerType bannerTypeFromExternal(String external) {
        if (external == null) {
            return null;
        }
        if (BannerTypeMultiplierValuesBannerType.cpm_banner.getLiteral().equals(external)) {
            return BannerType.CPM_BANNER;
        } else if (BannerTypeMultiplierValuesBannerType.cpm_video.getLiteral().equals(external)) {
            return BannerType.CPM_VIDEO;
        } else if (BannerTypeMultiplierValuesBannerType.cpm_outdoor.getLiteral().equals(external)) {
            return BannerType.CPM_OUTDOOR;
        } else if (external.equals("all")) {
            return null;
        } else {
            throw new IllegalStateException("Unknown banner type: " + external);
        }
    }
}
