package ru.yandex.direct.web.core.entity.bidmodifiers;

import java.util.List;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierInventory;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierInventoryAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.InventoryType;
import ru.yandex.direct.web.core.entity.bidmodifiers.model.BidModifierInventoryConditionWeb;
import ru.yandex.direct.web.core.entity.bidmodifiers.model.BidModifierInventoryWeb;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.web.core.entity.bidmodifiers.HelperConverter.booleanFromInt;
import static ru.yandex.direct.web.core.entity.bidmodifiers.HelperConverter.booleanToInt;

public class InventoryModifierConverter {

    private InventoryModifierConverter() {
    }

    static BidModifierInventory convert(BidModifierInventoryWeb inventoryModifier) {
        List<BidModifierInventoryAdjustment> conditions =
                mapList(inventoryModifier.getConditions(), InventoryModifierConverter::convert);

        BidModifierInventory bidModifier = new BidModifierInventory()
                .withType(BidModifierType.INVENTORY_MULTIPLIER)
                .withEnabled(booleanFromInt(inventoryModifier.getEnabled()))
                .withInventoryAdjustments(conditions);
        return bidModifier;
    }

    public static BidModifierInventoryAdjustment convert(BidModifierInventoryConditionWeb condition) {
        return new BidModifierInventoryAdjustment()
                .withPercent(condition.getPercent())
                .withInventoryType(inventoryTypeFromExternal(condition.getMultiplierType()));
    }

    static BidModifierInventoryConditionWeb convertToWeb(BidModifierInventoryAdjustment condition) {
        return new BidModifierInventoryConditionWeb()
                .withId(condition.getId())
                .withPercent(condition.getPercent())
                .withMultiplierType(condition.getInventoryType().toString().toLowerCase())
                .withLastChange(condition.getLastChange().toString());
    }

    public static BidModifierInventoryWeb convertToWeb(BidModifierInventory modifier) {
        List<BidModifierInventoryConditionWeb> conditions = mapList(modifier.getInventoryAdjustments(),
                InventoryModifierConverter::convertToWeb);

        return new BidModifierInventoryWeb()
                .withHierarchicalMultiplierId(modifier.getId())
                .withEnabled(booleanToInt(modifier.getEnabled()))
                .withLastChange(modifier.getLastChange().toString())
                .withConditions(conditions);
    }

    private static InventoryType inventoryTypeFromExternal(String external) {
        if (external == null) {
            return null;
        }

        switch (external) {
            case "inpage":
                return InventoryType.INPAGE;
            case "instream_web":
                return InventoryType.INSTREAM_WEB;
            case "interstitial":
                return InventoryType.INTERSTITIAL;
            case "inapp":
                return InventoryType.INAPP;
            case "inbanner":
                return InventoryType.INBANNER;
            case "rewarded":
                return InventoryType.REWARDED;
            case "preroll":
                return InventoryType.PREROLL;
            case "midroll":
                return InventoryType.MIDROLL;
            case "postroll":
                return InventoryType.POSTROLL;
            case "pauseroll":
                return InventoryType.PAUSEROLL;
            case "overlay":
                return InventoryType.OVERLAY;
            case "postroll_overlay":
                return InventoryType.POSTROLL_OVERLAY;
            case "postroll_wrapper":
                return InventoryType.POSTROLL_WRAPPER;
            case "inroll_overlay":
                return InventoryType.INROLL_OVERLAY;
            case "inroll":
                return InventoryType.INROLL;
            case "fullscreen":
                return InventoryType.FULLSCREEN;
            case "all":
                return null;
            default: {
                throw new IllegalStateException("Unknown inventory type: " + external);
            }
        }
    }
}
