package ru.yandex.direct.web.core.entity.bidmodifiers;

import java.util.List;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierTrafaretPosition;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierTrafaretPositionAdjustment;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifier.TrafaretPosition;
import ru.yandex.direct.web.core.entity.bidmodifiers.model.BidModifierTrafaretPositionConditionWeb;
import ru.yandex.direct.web.core.entity.bidmodifiers.model.BidModifierTrafaretPositionWeb;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.web.core.entity.bidmodifiers.HelperConverter.booleanFromInt;
import static ru.yandex.direct.web.core.entity.bidmodifiers.HelperConverter.booleanToInt;

public class TrafaretPositionModifierConverter {

    private TrafaretPositionModifierConverter() {
    }

    static BidModifierTrafaretPosition convert(BidModifierTrafaretPositionWeb trafaretPositionModifier) {
        List<BidModifierTrafaretPositionAdjustment> conditions =
                mapList(trafaretPositionModifier.getConditions(), TrafaretPositionModifierConverter::convert);

        return new BidModifierTrafaretPosition()
                .withType(BidModifierType.TRAFARET_POSITION_MULTIPLIER)
                .withEnabled(booleanFromInt(trafaretPositionModifier.getEnabled()))
                .withTrafaretPositionAdjustments(conditions);
    }

    public static BidModifierTrafaretPositionAdjustment convert(BidModifierTrafaretPositionConditionWeb condition) {
        return new BidModifierTrafaretPositionAdjustment()
                .withPercent(condition.getPercent())
                .withTrafaretPosition(trafaretPositionFromExternal(condition.getMultiplierType()));
    }

    static BidModifierTrafaretPositionConditionWeb convertToWeb(BidModifierTrafaretPositionAdjustment condition) {
        return new BidModifierTrafaretPositionConditionWeb()
                .withId(condition.getId())
                .withPercent(condition.getPercent())
                .withMultiplierType(condition.getTrafaretPosition().toString().toLowerCase())
                .withLastChange(condition.getLastChange().toString());
    }

    public static BidModifierTrafaretPositionWeb convertToWeb(BidModifierTrafaretPosition modifier) {
        List<BidModifierTrafaretPositionConditionWeb> conditions = mapList(modifier.getTrafaretPositionAdjustments(),
                TrafaretPositionModifierConverter::convertToWeb);

        return new BidModifierTrafaretPositionWeb()
                .withHierarchicalMultiplierId(modifier.getId())
                .withEnabled(booleanToInt(modifier.getEnabled()))
                .withLastChange(modifier.getLastChange().toString())
                .withConditions(conditions);
    }

    private static TrafaretPosition trafaretPositionFromExternal(String external) {
        if (external == null) {
            return null;
        }

        switch (external) {
            case "alone":
                return TrafaretPosition.ALONE;
            case "suggest":
                return TrafaretPosition.SUGGEST;
            case "all":
                return null;
            default: {
                throw new IllegalStateException("Unknown trafaret position: " + external);
            }
        }
    }
}
