package ru.yandex.direct.web.core.entity.bidmodifiers.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Модель для передачи корректировки, которая записывается на одну таблицу hierarchical_multipliers
 * (desktop, video, performance_tgo)
 */
public class BidModifierSingleWeb {
    @JsonProperty("hierarchical_multiplier_id")
    private long id;

    @JsonProperty("multiplier_pct")
    private int percent;

    @JsonProperty("last_change")
    private String lastChange;

    public long getId() {
        return id;
    }

    public BidModifierSingleWeb withId(long id) {
        this.id = id;
        return this;
    }

    public int getPercent() {
        return percent;
    }

    public BidModifierSingleWeb withPercent(int percent) {
        this.percent = percent;
        return this;
    }

    public String getLastChange() {
        return lastChange;
    }

    public BidModifierSingleWeb withLastChange(String lastChange) {
        this.lastChange = lastChange;
        return this;
    }
}
