package ru.yandex.direct.web.core.entity.bidmodifiers.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ComplexBidModifierWeb {
    @JsonProperty("demography_multiplier")
    private BidModifierDemographyWeb demographyModifier;

    @JsonProperty("retargeting_multiplier")
    private BidModifierRetargetingWeb retargetingModifier;

    @JsonProperty("geo_multiplier")
    private BidModifierGeoWeb geoModifier;

    @JsonProperty("mobile_multiplier")
    private BidModifierMobileWeb mobileModifier;

    @JsonProperty("desktop_multiplier")
    private BidModifierSingleWeb desktopModifier;

    @JsonProperty("tablet_multiplier")
    private BidModifierTabletWeb tabletModifier;

    @JsonProperty("desktop_only_multiplier")
    private BidModifierSingleWeb desktopOnlyModifier;

    @JsonProperty("smarttv_multiplier")
    private BidModifierSingleWeb smartTVModifier;

    @JsonProperty("weather_multiplier")
    private BidModifierWeatherWeb weatherModifier;

    @JsonProperty("video_multiplier")
    private BidModifierSingleWeb videoModifier;

    @JsonProperty("performance_tgo_multiplier")
    private BidModifierSingleWeb performanceTgoModifier;

    @JsonProperty("ab_segment_multiplier")
    private BidModifierABSegmentWeb abSegmentModifier;

    @JsonProperty("banner_type_multiplier")
    private BidModifierBannerTypeWeb bannerTypeModifier;

    @JsonProperty("inventory_multiplier")
    private BidModifierInventoryWeb inventoryModifier;

    @JsonProperty("trafaret_position_multiplier")
    private BidModifierTrafaretPositionWeb trafaretPositionModifier;

    @JsonProperty("expression_multipliers")
    private List<BidModifierExpressionWeb> bidModifierExpression;

    public BidModifierDemographyWeb getDemographyModifier() {
        return demographyModifier;
    }

    public ComplexBidModifierWeb withDemographyModifier(
            BidModifierDemographyWeb demographyModifier) {
        this.demographyModifier = demographyModifier;
        return this;
    }

    public BidModifierRetargetingWeb getRetargetingModifier() {
        return retargetingModifier;
    }

    public ComplexBidModifierWeb withRetargetingModifier(
            BidModifierRetargetingWeb retargetingModifier) {
        this.retargetingModifier = retargetingModifier;
        return this;
    }

    public BidModifierGeoWeb getGeoModifier() {
        return geoModifier;
    }

    public ComplexBidModifierWeb withGeoModifier(
            BidModifierGeoWeb geoModifier) {
        this.geoModifier = geoModifier;
        return this;
    }

    public BidModifierMobileWeb getMobileModifier() {
        return mobileModifier;
    }

    public ComplexBidModifierWeb withMobileModifier(
            BidModifierMobileWeb mobileModifier) {
        this.mobileModifier = mobileModifier;
        return this;
    }

    public BidModifierSingleWeb getDesktopModifier() {
        return desktopModifier;
    }

    public ComplexBidModifierWeb withDesktopModifier(
            BidModifierSingleWeb desktopModifier) {
        this.desktopModifier = desktopModifier;
        return this;
    }

    public BidModifierTabletWeb getTabletModifier() {
        return tabletModifier;
    }

    public ComplexBidModifierWeb withTabletModifier(
            BidModifierTabletWeb tabletModifier) {
        this.tabletModifier = tabletModifier;
        return this;
    }

    public BidModifierSingleWeb getDesktopOnlyModifier() {
        return desktopOnlyModifier;
    }

    public ComplexBidModifierWeb withDesktopOnlyModifier(
            BidModifierSingleWeb desktopOnlyModifier) {
        this.desktopOnlyModifier = desktopOnlyModifier;
        return this;
    }

    public BidModifierSingleWeb getSmartTVModifier() {
        return smartTVModifier;
    }

    public ComplexBidModifierWeb withSmartTVModifier(
            BidModifierSingleWeb smartTVModifier) {
        this.smartTVModifier = smartTVModifier;
        return this;
    }

    public BidModifierWeatherWeb getWeatherModifier() {
        return weatherModifier;
    }

    public ComplexBidModifierWeb withWeatherModifier(
            BidModifierWeatherWeb weatherModifier) {
        this.weatherModifier = weatherModifier;
        return this;
    }

    public BidModifierSingleWeb getVideoModifier() {
        return videoModifier;
    }

    public ComplexBidModifierWeb withVideoModifier(
            BidModifierSingleWeb videoModifier) {
        this.videoModifier = videoModifier;
        return this;
    }

    public BidModifierSingleWeb getPerformanceTgoModifier() {
        return performanceTgoModifier;
    }

    public ComplexBidModifierWeb withPerformanceTgoModifier(
            BidModifierSingleWeb performanceTgoModifier) {
        this.performanceTgoModifier = performanceTgoModifier;
        return this;
    }

    public BidModifierABSegmentWeb getAbSegmentModifier() {
        return abSegmentModifier;
    }

    public ComplexBidModifierWeb withABSegmentModifiers(
            BidModifierABSegmentWeb abSegmentModifiers) {
        this.abSegmentModifier = abSegmentModifiers;
        return this;
    }

    public BidModifierBannerTypeWeb getBannerTypeModifier() {
        return bannerTypeModifier;
    }

    public ComplexBidModifierWeb withBannerTypeModifier(BidModifierBannerTypeWeb bannerTypeModifier) {
        this.bannerTypeModifier = bannerTypeModifier;
        return this;
    }

    public BidModifierInventoryWeb getInventoryModifier() {
        return inventoryModifier;
    }

    public ComplexBidModifierWeb withInventoryModifier(BidModifierInventoryWeb inventoryModifier) {
        this.inventoryModifier = inventoryModifier;
        return this;
    }

    public List<BidModifierExpressionWeb> getBidModifierExpression() {
        return bidModifierExpression;
    }

    public BidModifierTrafaretPositionWeb getTrafaretPositionModifier() {
        return trafaretPositionModifier;
    }

    public ComplexBidModifierWeb withTrafaretPositionModifier(BidModifierTrafaretPositionWeb trafaretPositionModifier) {
        this.trafaretPositionModifier = trafaretPositionModifier;
        return this;
    }
}
