package ru.yandex.direct.web.core.entity.inventori.model;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class BannerFormatIncreasePercent {
    @ApiModelProperty(notes = "формат банера")
    @JsonProperty("format")
    private String format;

    @ApiModelProperty(notes = "процент, на который увеличится охват при добавлении формата баннера")
    @JsonProperty("increase_percent")
    private BigDecimal increasePercent;

    public String getFormat() {
        return format;
    }

    public BigDecimal getIncreasePercent() {
        return increasePercent;
    }

    public BannerFormatIncreasePercent withFormat(String format) {
        this.format = format;
        return this;
    }

    public BannerFormatIncreasePercent withIncreasePercent(BigDecimal increasePercent) {
        this.increasePercent = increasePercent;
        return this;
    }
}
