package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ParametersAreNonnullByDefault
@ApiModel(description = "Настройки Brandsafety")
public class Brandsafety {
    @ApiModelProperty(notes = "Расширенное ограничение по типам контента")
    @JsonProperty("is_enabled")
    private Boolean enabled;

    @ApiModelProperty(notes = "Дополнительные категории")
    @JsonProperty("additional_categories")
    private List<Long> additionalCategories;

    public Brandsafety() {
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public Brandsafety setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<Long> getAdditionalCategories() {
        return additionalCategories;
    }

    public Brandsafety setAdditionalCategories(List<Long> additionalCategories) {
        this.additionalCategories = additionalCategories;
        return this;
    }
}
