package ru.yandex.direct.web.core.entity.inventori.model;

import java.time.LocalDate;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

@ParametersAreNonnullByDefault
public class CampaignStrategy {
    @ApiModelProperty(notes = "Тип стратегии - MAX_REACH или MIN_CPM")
    @JsonProperty("type")
    private String type;

    @ApiModelProperty(notes = "Бюджет")
    @JsonProperty("budget")
    private Double budget;

    @ApiModelProperty(notes = "Дата начала показов")
    @JsonProperty("start_date")
    private LocalDate startDate;

    @ApiModelProperty(notes = "Дата окончания показов")
    @JsonProperty("end_date")
    private LocalDate endDate;

    @ApiModelProperty(notes = "Ограничение частоты показов")
    @JsonProperty("impression_limit")
    private ImpressionLimit impressionLimit;

    @ApiModelProperty(notes = "Средняя цена за тысячу показов")
    @JsonProperty("cpm")
    private Double cpm;

    @ApiModelProperty(notes = "Средняя цена за просмотр")
    @JsonProperty("cpv")
    private Double cpv;

    @ApiModelProperty(notes = "Продлевать автоматически период показов")
    @JsonProperty("auto_prolongation")
    private Long autoProlongation;

    public CampaignStrategy() {
    }

    public CampaignStrategy(String type, Double budget,
                            LocalDate startDate, LocalDate endDate,
                            ImpressionLimit impressionLimit,
                            @Nullable Double cpm,
                            @Nullable Long autoProlongation) {
        this.type = type;
        this.budget = budget;
        this.startDate = startDate;
        this.endDate = endDate;
        this.impressionLimit = impressionLimit;
        this.cpm = cpm;
        this.autoProlongation = autoProlongation;
    }

    @Nullable
    public String getType() {
        return type;
    }

    public CampaignStrategy withType(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public Double getBudget() {
        return budget;
    }

    public CampaignStrategy withBudget(@Nullable Double budget) {
        this.budget = budget;
        return this;
    }

    @Nullable
    public LocalDate getStartDate() {
        return startDate;
    }

    public CampaignStrategy withStartDate(@Nullable LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    public LocalDate getEndDate() {
        return endDate;
    }

    public CampaignStrategy withEndDate(@Nullable LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    public ImpressionLimit getImpressionLimit() {
        return impressionLimit;
    }

    public CampaignStrategy withImpressionLimit(@Nullable ImpressionLimit impressionLimit) {
        this.impressionLimit = impressionLimit;
        return this;
    }

    @Nullable
    public Double getCpm() {
        return cpm;
    }

    public CampaignStrategy withCpm(@Nullable Double cpm) {
        this.cpm = cpm;
        return this;
    }

    public Double getCpv() {
        return cpv;
    }

    public CampaignStrategy withCpv(Double cpv) {
        this.cpv = cpv;
        return this;
    }

    @Nullable
    public Long getAutoProlongation() {
        return autoProlongation;
    }

    public CampaignStrategy withAutoProlongation(@Nullable Long autoProlongation) {
        this.autoProlongation = autoProlongation;
        return this;
    }
}
