package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.web.core.model.retargeting.CryptaInterestTypeWeb;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionRuleType;

public class Condition {
    @ApiModelProperty(required = true, notes = "тип формулы")
    @JsonProperty("type")
    private RetargetingConditionRuleType type;

    @ApiModelProperty(notes = "длительность интереса крипты")
    @JsonProperty("interest_type")
    private CryptaInterestTypeWeb interestType;

    @ApiModelProperty(required = true, notes = "список сегментов/аудиторий")
    @JsonProperty("goals")
    private List<Goal> goals;

    public Condition() {
    }

    public Condition(RetargetingConditionRuleType type,
                     List<Goal> goals) {
        this.type = type;
        this.goals = goals;
    }

    public RetargetingConditionRuleType getType() {
        return type;
    }

    public Condition withType(RetargetingConditionRuleType type) {
        this.type = type;
        return this;
    }

    public CryptaInterestTypeWeb getInterestType() {
        return interestType;
    }

    public Condition withInterestType(CryptaInterestTypeWeb interestType) {
        this.interestType = interestType;
        return this;
    }

    public List<Goal> getGoals() {
        return goals;
    }

    public Condition withGoals(List<Goal> goals) {
        this.goals = goals;
        return this;
    }
}
