package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.core.entity.adgroup.model.TargetTagEnum;
import ru.yandex.direct.inventori.model.request.PageBlock;

@ApiModel(description = "Запрос прогноза охвата в inventori")
public class CpmForecastRequest {
    @ApiModelProperty(notes = "ID существующей кампании")
    @JsonProperty("campaign_id")
    private Long campaignId;

    @ApiModelProperty(notes = "ID примера для новой кампании")
    @JsonProperty("new_campaign_example_type")
    private Integer newCampaignExampleType;

    @ApiModelProperty(notes = "Обновленное гео групп")
    @JsonProperty("adgroups_geo")
    private List<AdGroupGeo> adGroupGeos;

    @ApiModelProperty(notes = "Данные стратегии")
    @JsonProperty("strategy")
    private CampaignStrategy strategy;

    @JsonProperty("traffic_type_corrections")
    private TrafficTypeCorrectionsWeb trafficTypeCorrections;

    @ApiModelProperty(notes = "Тип кампании")
    @JsonProperty("campaign_type")
    private CpmCampaignType cpmCampaignType;

    @ApiModelProperty(notes = "Тип главной страницы")
    @JsonProperty("frontpage_type")
    private YndxFrontpagePageType yndxFrontpagePageType;

    @ApiModelProperty(notes = "Стандарт видимости")
    @JsonProperty("impression_standard_time")
    private ImpressionStandardTimeWeb impressionStandardTime;

    @ApiModelProperty(notes = "Настройки eshows")
    @JsonProperty("eshows_settings")
    private EshowsSettingsWeb eshowsSettings;

    @ApiModelProperty(notes = "Типы нацеливания")
    @JsonProperty("target_tags")
    private List<TargetTagEnum> targetTags;

    @ApiModelProperty(notes = "Brand safety")
    @JsonProperty("brandsafety")
    private Brandsafety brandsafety;

    @ApiModelProperty(notes = "Белый список пейджей/блоков (из ПИ)")
    @JsonProperty("page_blocks")
    private List<PageBlock> pageBlocks;

    public CpmForecastRequest() {
    }

    public CpmForecastRequest(Long campaignId, Integer newCampaignExampleType, CampaignStrategy strategy) {
        this.campaignId = campaignId;
        this.newCampaignExampleType = newCampaignExampleType;
        this.strategy = strategy;
    }

    public CpmForecastRequest(Long campaignId, Integer newCampaignExampleType, CampaignStrategy strategy,
                              TrafficTypeCorrectionsWeb trafficTypeCorrections) {
        this(campaignId, newCampaignExampleType, strategy);
        this.trafficTypeCorrections = trafficTypeCorrections;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public CpmForecastRequest withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Integer getNewCampaignExampleType() {
        return newCampaignExampleType;
    }

    public CpmForecastRequest withNewCampaignExampleType(Integer newCampaignExampleType) {
        this.newCampaignExampleType = newCampaignExampleType;
        return this;
    }

    public CampaignStrategy getStrategy() {
        return strategy;
    }

    public CpmForecastRequest withStrategy(CampaignStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CpmForecastRequest withTrafficTypeCorrections(TrafficTypeCorrectionsWeb trafficTypeCorrections) {
        this.trafficTypeCorrections = trafficTypeCorrections;
        return this;
    }

    @Nullable
    public TrafficTypeCorrectionsWeb getTrafficTypeCorrections() {
        return trafficTypeCorrections;
    }

    @Nullable
    public YndxFrontpagePageType getYndxFrontpagePageType() {
        return yndxFrontpagePageType;
    }

    @Nullable
    public CpmCampaignType getCpmCampaignType() {
        return cpmCampaignType;
    }

    public CpmForecastRequest withCpmCampaignType(CpmCampaignType cpmCampaignType) {
        this.cpmCampaignType = cpmCampaignType;
        return this;
    }

    public CpmForecastRequest withYndxFrontpagePageType(YndxFrontpagePageType yndxFrontpagePageType) {
        this.yndxFrontpagePageType = yndxFrontpagePageType;
        return this;
    }

    public List<AdGroupGeo> getAdGroupGeos() {
        return adGroupGeos;
    }

    public CpmForecastRequest withAdGroupGeos(List<AdGroupGeo> adGroupGeos) {
        this.adGroupGeos = adGroupGeos;
        return this;
    }

    public ImpressionStandardTimeWeb getImpressionStandardTime() {
        return impressionStandardTime;
    }

    public CpmForecastRequest withImpressionStandardTime(ImpressionStandardTimeWeb impressionStandardTime) {
        this.impressionStandardTime = impressionStandardTime;
        return this;
    }

    public EshowsSettingsWeb getEshowsSettings() {
        return eshowsSettings;
    }

    public CpmForecastRequest withEshowsSettings(EshowsSettingsWeb eshowsSettings) {
        this.eshowsSettings = eshowsSettings;
        return this;
    }

    @Nullable
    public List<TargetTagEnum> getTargetTags() {
        return targetTags;
    }

    public CpmForecastRequest withTargetTags(List<TargetTagEnum> targetTags) {
        this.targetTags = targetTags;
        return this;
    }

    public Brandsafety getBrandsafety() {
        return brandsafety;
    }

    public CpmForecastRequest withBrandsafety(Brandsafety brandsafety) {
        this.brandsafety = brandsafety;
        return this;
    }

    @Nullable
    public List<PageBlock> getPageBlocks() {
        return pageBlocks;
    }

    public CpmForecastRequest withPageBlocks(List<PageBlock> pageBlocks) {
        this.pageBlocks = pageBlocks;
        return this;
    }
}
