package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class CpmForecastSuccessResult {

    @JsonProperty("gradient")
    private final List<ForecastSector> sectors;

    @JsonProperty("recommended_price")
    private final double recommendedPrice;

    public CpmForecastSuccessResult(double recommendedPrice, List<ForecastSector> sectors) {
        this.sectors = sectors;
        this.recommendedPrice = recommendedPrice;
    }

    public List<ForecastSector> getSectors() {
        return sectors;
    }

    public double getRecommendedPrice() {
        return recommendedPrice;
    }
}
