package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.Collection;

import javax.annotation.Nullable;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.Collections.emptySet;

public class CpmTrafficLightPredictionResult {

    private CpmForecastRequest request;
    private CpmTrafficLightPredictionSuccessResult result;
    private Collection<Defect> errors;

    public CpmTrafficLightPredictionResult(
            CpmForecastRequest request,
            @Nullable CpmTrafficLightPredictionSuccessResult result,
            Collection<Defect> errors) {
        this.request = request;
        this.result = result;
        this.errors = errors;
    }

    @Nullable
    public CpmTrafficLightPredictionSuccessResult getResult() {
        return result;
    }

    public ValidationResult<CpmForecastRequest, Defect> getErrors() {
        return new ValidationResult<>(request, errors, emptySet());
    }

    public boolean isSuccessful() {
        return result != null;
    }
}
