package ru.yandex.direct.web.core.entity.inventori.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CpmTrafficLightPredictionSuccessResult {

    @JsonProperty("traffic_light_color")
    private final int trafficLightColor;

    @JsonProperty("recommended_price")
    private final Double recommendedPrice;

    public CpmTrafficLightPredictionSuccessResult(int trafficLightColor, @Nullable Double recommendedPrice) {
        this.trafficLightColor = trafficLightColor;
        this.recommendedPrice = recommendedPrice;
    }

    public int getTrafficLightColor() {
        return trafficLightColor;
    }

    @Nullable
    public Double getRecommendedPrice() {
        return recommendedPrice;
    }
}
