package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class Error {
    @ApiModelProperty(notes = "ID сегмента/цели/аудитории")
    @JsonProperty("goal_id")
    private Long goalId;

    @ApiModelProperty(notes = "тип исключения")
    @JsonProperty("type")
    private String type;

    public Error() {
    }

    public Error(Long goalId, String type) {
        this.goalId = goalId;
        this.type = type;
    }

    public Long getGoalId() {
        return goalId;
    }

    public String getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error) o;
        return Objects.equals(goalId, error.goalId) &&
                Objects.equals(type, error.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goalId, type);
    }
}
