package ru.yandex.direct.web.core.entity.inventori.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ParametersAreNonnullByDefault
@ApiModel(description = "Настройки eshows")
public class EshowsSettingsWeb {

    @ApiModelProperty(notes = "Степень включения eshows для баннеров")
    @JsonProperty("banner_rate")
    private EshowsRateWeb bannerRate;

    @ApiModelProperty(notes = "Степень включения eshows для видео")
    @JsonProperty("video_rate")
    private EshowsRateWeb videoRate;

    @ApiModelProperty(notes = "Тип оптимизации для видео")
    @JsonProperty("video_type")
    private EshowsVideoTypeWeb videoType;

    public EshowsSettingsWeb() {
    }

    public EshowsSettingsWeb(EshowsRateWeb bannerRate, EshowsRateWeb videoRate, EshowsVideoTypeWeb videoType) {
        this.bannerRate = bannerRate;
        this.videoRate = videoRate;
        this.videoType = videoType;
    }

    public EshowsRateWeb getBannerRate() {
        return bannerRate;
    }

    public EshowsSettingsWeb withBannerRate(EshowsRateWeb bannerRate) {
        this.bannerRate = bannerRate;
        return this;
    }

    public EshowsRateWeb getVideoRate() {
        return videoRate;
    }

    public EshowsSettingsWeb withVideoRate(EshowsRateWeb videoRate) {
        this.videoRate = videoRate;
        return this;
    }

    public EshowsVideoTypeWeb getVideoType() {
        return videoType;
    }

    public EshowsSettingsWeb withVideoType(EshowsVideoTypeWeb videoType) {
        this.videoType = videoType;
        return this;
    }
}
