package ru.yandex.direct.web.core.entity.inventori.model;


import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import reactor.util.annotation.NonNull;

@ParametersAreNonnullByDefault
public class ForecastSector {
    @JsonProperty("color")
    private final String color;

    @JsonProperty("min")
    private final Double min;

    @JsonProperty("max")
    private final Double max;

    public ForecastSector(String color, Double min, Double max) {
        this.color = color;
        this.min = min;
        this.max = max;
    }

    public ForecastSector(String color, Double min) {
        this.color = color;
        this.min = min;
        this.max = null;
    }

    @NonNull
    public Double getMin() {
        return min;
    }

    @Nullable
    public Double getMax() {
        return max;
    }

    @NonNull
    public String getColor() {
        return color;
    }
}
