package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.Collection;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.Collections.emptySet;

/**
 * Обработанный результат вызова CPM-прогнозатора, содержит результат выполнения операции - ответ прогнозатора, ответ
 * прогнозатора + нефатальные ошибки или фатальные ошибки (тогда операция считается зафейленной, и ответ прогнозатора
 * null).
 */
@ParametersAreNonnullByDefault
public class GeneralCpmForecastResult {
    private GeneralCpmRecommendationRequest request;
    private CpmForecastSuccessResult result;
    private Collection<Defect> errors;

    public GeneralCpmForecastResult(GeneralCpmRecommendationRequest request,
                             @Nullable CpmForecastSuccessResult result,
                             Collection<Defect> errors) {
        this.request = request;
        this.result = result;
        this.errors = errors;
    }

    /**
     * @return успешный результат запроса к прогнозатору с данными прогноза, если есть (для неудачных запросов null)
     */
    @Nullable
    public CpmForecastSuccessResult getResult() {
        return result;
    }

    public void setResult(CpmForecastSuccessResult result) {
        this.result = result;
    }

    /**
     * @return ошибки, возникшие во время обработки запроса, в виде ValidationResult
     */
    public ValidationResult<GeneralCpmRecommendationRequest, Defect> getErrors() {
        return new ValidationResult<>(request, errors, emptySet());
    }

    /**
     * @return являлась ли операция успешной
     */
    public boolean isSuccessful() {
        return result != null;
    }
}
