package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.core.entity.uac.model.DeviceType;
import ru.yandex.direct.core.entity.uac.model.InventoryType;
import ru.yandex.direct.inventori.model.request.GroupType;

@ApiModel(description = "Запрос прогноза охвата в inventori")
public class GeneralCpmRecommendationRequest {
    @ApiModelProperty(notes = "ID существующей кампании")
    @JsonProperty("campaign_id")
    private Long campaignId;

    @ApiModelProperty(notes = "география")
    @JsonProperty("geo")
    private Set<Integer> geo;

    @ApiModelProperty(notes = "Данные стратегии")
    @JsonProperty("strategy")
    private CampaignStrategy strategy;

    @ApiModelProperty(notes = "Тип кампании")
    @JsonProperty("campaign_type")
    private CpmCampaignType cpmCampaignType;

    @ApiModelProperty(notes = "форматы баннеров")
    @JsonProperty("block_sizes")
    private List<BlockSize> blockSizes;

    @ApiModelProperty(notes = "форматы видео креативов")
    @JsonProperty("video_creatives")
    private List<VideoCreativeWeb> videoCreatives;

    @ApiModelProperty(notes = "формулы ретаргетинга по аудиториям/сегментам")
    @JsonProperty("conditions")
    private List<Condition> conditions;

    @ApiModelProperty(notes = "тип группы объявлений")
    @JsonProperty("group_type")
    private GroupType groupType;

    @ApiModelProperty(notes = "признак того, что кампания запускается с BrandLift")
    @JsonProperty("has_brandlift")
    protected  Boolean hasBrandlift;

    @ApiModelProperty(notes = "признак того, что кампания запускается с BrandSafety")
    @JsonProperty(value = "excluded_bs_categories")
    private List<String> excludedBsCategories;

    @ApiModelProperty(notes = "Черный список доменов")
    @JsonProperty("excluded_domains")
    protected  Set<String> excludedDomains;

    @ApiModelProperty(notes = "Корректировки на инвентарь")
    @JsonProperty("inventory_types")
    protected  Set<InventoryType> inventoryTypes;

    @ApiModelProperty(notes = "Корректировки на платформу")
    @JsonProperty("device_types")
    protected  Set<DeviceType> deviceTypes;

    public Long getCampaignId() {
        return campaignId;
    }

    public GeneralCpmRecommendationRequest withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public CampaignStrategy getStrategy() {
        return strategy;
    }

    public GeneralCpmRecommendationRequest withStrategy(CampaignStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @Nullable
    public CpmCampaignType getCpmCampaignType() {
        return cpmCampaignType;
    }

    public GeneralCpmRecommendationRequest withCpmCampaignType(CpmCampaignType cpmCampaignType) {
        this.cpmCampaignType = cpmCampaignType;
        return this;
    }

    public Set<Integer> getGeo() {
        return geo;
    }

    public GeneralCpmRecommendationRequest withGeo(Set<Integer> geo) {
        this.geo = geo;
        return this;
    }

    public List<BlockSize> getBlockSizes() {
        return blockSizes;
    }

    public GeneralCpmRecommendationRequest withBlockSizes(
            List<BlockSize> blockSizes)
    {
        this.blockSizes = blockSizes;
        return this;
    }

    public List<VideoCreativeWeb> getVideoCreatives() {
        return videoCreatives;
    }

    public GeneralCpmRecommendationRequest withVideoCreatives(
            List<VideoCreativeWeb> videoCreatives)
    {
        this.videoCreatives = videoCreatives;
        return this;
    }

    public List<Condition> getConditions() {
        return conditions;
    }

    public GeneralCpmRecommendationRequest withConditions(
            List<Condition> conditions)
    {
        this.conditions = conditions;
        return this;
    }

    public GroupType getGroupType() {
        return groupType;
    }

    public GeneralCpmRecommendationRequest withGroupType(GroupType groupType) {
        this.groupType = groupType;
        return this;
    }

    public Boolean getHasBrandlift() {
        return hasBrandlift;
    }

    public GeneralCpmRecommendationRequest withHasBrandlift(Boolean hasBrandlift) {
        this.hasBrandlift = hasBrandlift;
        return this;
    }

    public List<String> getExcludedBsCategories() {
        return excludedBsCategories;
    }

    public GeneralCpmRecommendationRequest withExcludedBsCategories(List<String> excludedBsCategories) {
        this.excludedBsCategories = excludedBsCategories;
        return this;
    }

    public Set<String> getExcludedDomains() {
        return excludedDomains;
    }

    public GeneralCpmRecommendationRequest withExcludedDomains(Set<String> excludedDomains) {
        this.excludedDomains = excludedDomains;
        return this;
    }

    public Set<InventoryType> getInventoryTypes() {
        return inventoryTypes;
    }

    public GeneralCpmRecommendationRequest withInventoryTypes(Set<InventoryType> inventoryTypes) {
        this.inventoryTypes = inventoryTypes;
        return this;
    }

    public Set<DeviceType> getDeviceTypes() {
        return deviceTypes;
    }

    public GeneralCpmRecommendationRequest withDeviceTypes(Set<DeviceType> deviceTypes) {
        this.deviceTypes = deviceTypes;
        return this;
    }
}
