package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.Collection;

import javax.annotation.Nullable;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.Collections.emptySet;

public class GeneralCpmRecommendationResult {
    private GeneralCpmRecommendationRequest request;
    private GeneralCpmRecommendationSuccessResult result;
    private Collection<Defect> errors;
    private String requestId;

    public GeneralCpmRecommendationResult(String requestId, GeneralCpmRecommendationRequest request,
            @Nullable GeneralCpmRecommendationSuccessResult result,
            Collection<Defect> errors) {
        this.requestId = requestId;
        this.request = request;
        this.result = result;
        this.errors = errors;
    }

    public String getRequestId() {
        return requestId;
    }

    /**
     * @return успешный результат запроса к прогнозатору с данными прогноза, если есть (для неудачных запросов null)
     */
    @Nullable
    public GeneralCpmRecommendationSuccessResult getResult() {
        return result;
    }

    public void setResult(GeneralCpmRecommendationSuccessResult result) {
        this.result = result;
    }

    /**
     * @return ошибки, возникшие во время обработки запроса, в виде ValidationResult
     */
    public ValidationResult<GeneralCpmRecommendationRequest, Defect> getErrors() {
        return new ValidationResult<>(request, errors, emptySet());
    }

    /**
     * @return являлась ли операция успешной
     */
    public boolean isSuccessful() {
        return result != null;
    }
}
