package ru.yandex.direct.web.core.entity.inventori.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class GeneralCpmRecommendationSuccessResult {
    @JsonProperty("traffic_light_color")
    private final int trafficLightColor;

    @JsonProperty("recommended_price")
    private final Double recommendedPrice;

    @JsonProperty("target_events_left_border")
    private final Long targetEventsLeftBorder;

    @JsonProperty("target_events_right_border")
    private final Long targetEventsRightBorder;

    @JsonProperty("reach_left_border")
    private final Long reachLeftBorder;

    @JsonProperty("reach_right_border")
    private final Long reachRightBorder;

    public GeneralCpmRecommendationSuccessResult(int trafficLightColor, Double recommendedPrice,
            Long targetEventsLeftBorder, Long targetEventsRightBorder, Long reachLeftBorder,
            Long reachRightBorder) {
        this.trafficLightColor = trafficLightColor;
        this.recommendedPrice = recommendedPrice;
        this.targetEventsLeftBorder = targetEventsLeftBorder;
        this.targetEventsRightBorder = targetEventsRightBorder;
        this.reachLeftBorder = reachLeftBorder;
        this.reachRightBorder = reachRightBorder;
    }

    public int getTrafficLightColor() {
        return trafficLightColor;
    }

    public Double getRecommendedPrice() {
        return recommendedPrice;
    }

    public Long getTargetEventsLeftBorder() {
        return targetEventsLeftBorder;
    }

    public Long getTargetEventsRightBorder() {
        return targetEventsRightBorder;
    }

    public Long getReachLeftBorder() {
        return reachLeftBorder;
    }

    public Long getReachRightBorder() {
        return reachRightBorder;
    }
}
