package ru.yandex.direct.web.core.entity.inventori.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class Goal {
    @ApiModelProperty(required = true, notes = "ID сегмента/аудитории")
    @JsonProperty("id")
    private Long id;

    @ApiModelProperty(notes = "дней")
    @JsonProperty("time")
    private Integer time;

    public Goal() {
    }

    public Goal(Long id, Integer time) {
        this.id = id;
        this.time = time;
    }

    public Long getId() {
        return id;
    }

    public Integer getTime() {
        return time;
    }

    public Goal withId(Long id) {
        this.id = id;
        return this;
    }

    public Goal withTime(Integer time) {
        this.time = time;
        return this;
    }

}
