package ru.yandex.direct.web.core.entity.inventori.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class ImpressionLimit {
    @ApiModelProperty(notes = "показов не более")
    @JsonProperty("impressions")
    private Long impressions;

    @ApiModelProperty(notes = "за срок в днях")
    @JsonProperty("days")
    private Long days;

    public ImpressionLimit() {
    }

    public ImpressionLimit(Long impressions, Long days) {
        this.impressions = impressions;
        this.days = days;
    }

    public Long getImpressions() {
        return impressions;
    }

    public ImpressionLimit withImpressions(Long impressions) {
        this.impressions = impressions;
        return this;
    }

    public Long getDays() {
        return days;
    }

    public ImpressionLimit withDays(Long days) {
        this.days = days;
        return this;
    }
}
